% =========================================================================
%   Praktikum MATLAB/Simulink I
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Versuch 5
% Teil 5.2 Regelung des Ventilators in Simulink
clc
clear all

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 5.2.1 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Parameter


%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 5.2.2 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sim('Modell_linVentilator', 5);

x = (0:0.2:5).';
y = 131.912 * ones(size(x));




figure();
plot(x, y, '--k');
hold on;
plot(linVenti.time, linVenti.signals.values, 'linewidth', 2);
xlabel('Time (sec)');
ylabel('$$\omega(1/sec)$$', 'interpreter', 'latex');
ylim([0 140]);
xlim([0 5]);
grid on;
set(gca(), 'yTick', (0:30:120))
set(gca(), 'YTickLabel', {'0', '30', '60', '90', '120'});        
title('Step Response');


%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 5.2.3 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Regler implementieren
Reglerimplementierung

% P-Regler
sim('VentilatorPRegler', 5e-4);

% PI-Regler
sim('VentilatorPIRegler', 5e-4);

x = (0:0.2e-4:5e-4).';
y = ones(size(x));

figure();
plot(x, y, '--');
hold on;
plot(Venti_PI.time, Venti_PI.signals.values, 'linewidth', 2);
xlabel('Time (sec)');
ylabel('$$\omega\ (1/sec)$$', 'interpreter', 'latex');
ylim([0 1.5]);
xlim([0 5e-4]);
grid on;
title('Step Response');


%PI_Betragsopt.-Regler
sim('VentilatorPIReglerBetrag', 5e-4);

x = (0:0.2e-4:5e-4).';
y = ones(size(x));

figure;
plot(x, y, '--k');
hold on;
plot(Venti_PIBetrag.time, Venti_PIBetrag.signals.values, 'linewidth', 2);
xlabel('Time (sec)');
ylabel('$$\omega\ (1/sec)$$', 'interpreter', 'latex');
ylim([0 1.5]);
xlim([0 5e-4]);
grid on;
title('Step Response');


%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 5.2.4 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% P-Regler
sim('VentilatorPRegler_nichtl', 5e-4);

% PI-Regler
sim('VentilatorPIRegler_nichtl', 5e-4);

%PI_Betragsopt.-Regler
sim('VentilatorPIReglerBetrag_nichtl', 5e-4);

